/* ============ */
/* secortst.c	*/
/* ============ */
#include <math.h>
#include <srcrdefs.h>
#include <miscdefs.h>
#include <stdio.h>
#include <stdlib.h>

#define NUM_PROBS	100

INIT_DATA_STRU	 InitialData;
SERCOR_DATA_STRU SerCorData;

double	ChiSqProbs[NUM_PROBS];

/* ==================================================================== */
/* SerialCorrelationTest - Calculates Serial-Correlation Statistics	*/
/* ==================================================================== */
void
main(void)
{
    UINT    k;
    long    TotVariates = 0;
    double  KnMinusStat, KnMinusProb, KnPlusStat, KnPlusProb;

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\n\tS E R I A L  C O R R E L A T I O N  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n");
    fflush(NULL);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT) (-1)) ?
	" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    /* -------------------------------------- */
    /* Set Address of Random Number Generator */
    /* -------------------------------------- */
    SerCorData.RandFun = InitialData.RandFun;

    /* --------------------------------------------------------- */
    /* Initialize Control Parameters for Serial Correlation Test */
    /* --------------------------------------------------------- */
    SetSerialCorrelationControls(&SerCorData);

    for (k = 0; k < NUM_PROBS; ++k)
    {
	CalcSerCorChiSq(&SerCorData);

	if (SerCorData.CallStatus != OK)
	{
	    fprintf(stderr, "Problem in CalcSerCorChiSq()\n");
	    break;
	}

	ChiSqProbs[k] = SerCorData.ChiSqProb;

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k + 1, NUM_PROBS, TotVariates += SerCorData.NumVarPerPass);
    }

    fprintf(stderr, "\n"); fflush(NULL);

    if (SerCorData.CallStatus == OK)
    {
	KSCalc(ChiSqProbs, NUM_PROBS, &KnPlusStat, &KnPlusProb,
	    &KnMinusStat, &KnMinusProb);

	printf("\nKolmogorov-Smirnov Statistics and Probabilities"
	    " on Chi-Square Data\n");

	printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	    sqrt((double) NUM_PROBS) * KnPlusStat, 100 * KnPlusProb);

	printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	    sqrt((double) NUM_PROBS) * KnMinusStat, 100 * KnMinusProb);

	printf("\nAsymptotic Standard Deviation\t\t%+f\n",
		1.0 / sqrt(SerCorData.NumVarPerPass));
	printf("Actual Standard Deviation\t\t%+f\n",
		sqrt(SerCorData.TotSos / SerCorData.TotCoefs));
	printf("Actual Mean of Coefficients\t\t%+f\n",
		SerCorData.TotSum / (NUM_PROBS * SerCorData.NumCoefs));
	printf("\nFraction of serial correlations\t\t%.f / %.f (%.2f%%)\n"
		"more than two standard deviations\n"
		"from theoretical mean of zero.\n",
		SerCorData.NumOutliers, SerCorData.TotCoefs,
		100.0 * SerCorData.NumOutliers / SerCorData.TotCoefs);

	printf("\nThis Run Required %ld Random Numbers\n\n",
		TotVariates);
    }
}
